
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Tue Dec 14 15:05:13 2004
   *  Last modified   :  %modify_time%
   */
  /** @file 
   *  \brief DES ATP test vectors
   *
   *  \version CRYS_Ext_ATP_DES_Acceptance_test_vectors.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
    
/* disabling pc lint warning regarding to few initializers in braces :
   Too few initializers for aggregate 'unknown-name' */ 
/*lint --e{785} */   
    
/***************************
 * File Name:                                                           
 *  CRYS_ATP_TST_DES_Acceptance_test_vectors.c      
 *
 * Description:                                                                 
 *  This file contatind the test vectors used for DES Acceptance tests                              
 *
 **************************/

/***** Include Files ******/
#include "CRYS_error.h" 
#include "CRYS_Ext_ATP_DES_Acceptance.h"

/******** Defines ********/ 
/******** Enums **********/ 
/******** Typedefs *********/ 
/******** Global Data ********/ 
/***** Private function prototype ******/ 
/******** Public Functions *****/ 
/******** Private Functions ******/ 
TST_ExtApp_DES_TestDataStruct SEP_DES_Acceptance_TestData[] =
{
        /************/
        /*        DES ECB vectors         */
        /************/
	{ 
        {"Acceptance test - DES/ECB/3-Keys/1536ByteData "},
        /*TST_Key*/ 
        {{0xc8,0x2b,0x1e,0x9d,0x0a,0x32,0xdf,0x1c}, 
        {0x85,0x1d,0x4b,0x92,0x3c,0xf2,0x22,0x49}, 
        {0x9f,0x6e,0xfe,0x06,0xb1,0x99,0x94,0x3c}},
        CRYS_DES_3_KeysInUse, 
        /*TST_IvCounter*/
        {0},
        /*TST_input_data*/
        {0x4d,0x6c,0xc9,0xb2,0x6a,0x9d,0xdf,0xb9,0xbb,0xb6,0xac,0x47,0x6e,0xc1,0x66,0xcc,
        0x0a,0xb3,0x79,0x12,0xf7,0xe7,0x2a,0x5d,0x41,0xcb,0x7a,0xb6,0x99,0xda,0x4d,0x84,
        0x9d,0xca,0xcb,0x5c,0x59,0x06,0x07,0x1a,0x0d,0x5e,0xde,0x31,0x30,0xfd,0x23,0x3f,
        0xb6,0x9c,0xf9,0xe5,0x8f,0xf6,0x7f,0xd5,0x70,0x7c,0xb3,0x2c,0xd5,0x49,0x90,0x03,
        0x47,0x58,0x7a,0x40,0xda,0xf5,0xdc,0xb2,0xfb,0x71,0x10,0x5e,0x68,0x1a,0x7f,0x13,
        0x80,0x6a,0x09,0x45,0xbd,0x7f,0xa7,0x18,0x7f,0xcb,0x4e,0xba,0x0b,0x0d,0x17,0xf6,
        0xd3,0x80,0x9e,0x06,0xf8,0x52,0xa7,0xa9,0x0d,0x57,0x08,0x76,0x1e,0xff,0xc3,0x70,
        0xf0,0x86,0x72,0xda,0x8b,0x6a,0xe8,0x4d,0xf6,0x22,0x15,0x07,0x42,0x0d,0x2a,0x86,
        0xc9,0xa9,0xfe,0x56,0xb8,0x05,0xb0,0x27,0xcb,0x79,0x8f,0x22,0x58,0x94,0x36,0x7d,
        0x8f,0x56,0xfb,0x4d,0x00,0x9f,0x8b,0x9c,0x5e,0xe8,0xce,0xbc,0x82,0x31,0x11,0xda,
        0xb2,0x3a,0x63,0xd6,0x24,0xf6,0x3f,0x53,0xbe,0x3d,0x6c,0x0a,0x20,0xc1,0x22,0x63,
        0xe4,0x43,0x6e,0x46,0x24,0x07,0xd7,0x2e,0x3d,0x85,0x42,0x80,0xd3,0x61,0x13,0x1c,
        0x16,0x9d,0x95,0x31,0x43,0x0e,0x9c,0x55,0x6d,0x0c,0x69,0xd5,0x7d,0x6e,0xcd,0x49,
        0x78,0xb6,0x92,0x6c,0x00,0x88,0x16,0x2b,0x1e,0x61,0x39,0xfc,0x3e,0x85,0x79,0x71,
        0x7b,0x39,0x5c,0x0d,0x1d,0x33,0x0f,0x56,0x60,0x4f,0x4c,0x2b,0x78,0x83,0x80,0x58,
        0xd1,0x15,0x2e,0x68,0x9b,0x0b,0x8e,0xbb,0x86,0xe4,0x7b,0xd8,0xca,0x85,0x8c,0x03,
        0x6b,0x76,0x80,0x13,0xbb,0x4e,0xdf,0x7e,0x20,0x6c,0xde,0xb6,0x17,0xe8,0x83,0xb8,
        0x79,0xc9,0x0b,0xe1,0xfe,0x79,0x89,0x04,0xff,0x76,0xcf,0xbb,0x80,0x49,0x91,0xfa,
        0x6d,0xbc,0xc8,0xea,0x24,0x48,0x55,0xf4,0x34,0xcd,0xe7,0x1b,0x64,0x86,0x1e,0x90,
        0xf8,0x3b,0xf1,0x80,0x2f,0xb8,0x4d,0x31,0x10,0x7f,0xfe,0x4d,0x66,0xba,0xd3,0x7e,
        0x0a,0x73,0xfd,0x3a,0x60,0x07,0xb9,0xe1,0x24,0xd8,0x2f,0x05,0x67,0x43,0x99,0x08,
        0xd4,0xd2,0xa7,0xed,0x38,0xb2,0x22,0x68,0x42,0x67,0xd1,0x37,0x87,0xbe,0x99,0xb5,
        0xc8,0x03,0xe7,0xad,0x78,0x75,0x53,0x6c,0x79,0xf7,0x7d,0x1a,0x27,0x08,0x3b,0x4a,
        0x97,0xf5,0xf7,0xcf,0x20,0x4d,0x52,0xd1,0x1b,0x96,0x0d,0x21,0xe8,0x3e,0x2a,0xca,
        0x32,0xd5,0x4e,0xe9,0x73,0x79,0x6a,0xbe,0xba,0x91,0x9a,0x02,0xac,0xbe,0x4e,0x7b,
        0xc8,0x0e,0xa7,0xcf,0xf0,0x73,0x24,0x96,0x25,0x74,0x7d,0xb2,0x93,0x23,0xcf,0xe3,
        0xcd,0x4f,0xfa,0x96,0x59,0xfa,0x47,0xfe,0x6f,0x0d,0x4f,0x66,0xfe,0x4b,0x18,0xc6,
        0xf0,0x84,0x80,0x94,0xaf,0x0b,0xdf,0xdc,0xe8,0x6a,0xe8,0x93,0x8f,0x53,0xd0,0x29,
        0x23,0xda,0xb3,0x5d,0x33,0xe2,0x33,0x55,0x21,0xd5,0x62,0xee,0x26,0x99,0xe2,0x51,
        0x96,0xbf,0x4a,0xc7,0x65,0xfd,0xcc,0xce,0xeb,0xde,0x15,0x6c,0xe4,0xb8,0x75,0xc3,
        0xbb,0xdf,0x40,0xe6,0x08,0x18,0x74,0xeb,0x57,0x50,0x9b,0x41,0x2b,0x8e,0xf3,0x44,
        0x42,0x27,0xcd,0x0f,0x1b,0x31,0x33,0x91,0xb6,0x39,0xcd,0xe4,0x9b,0x39,0x06,0xd9,
        0x1d,0xc4,0x6a,0xd8,0xe0,0x84,0x52,0xe7,0x99,0xe6,0xc4,0x08,0x15,0x14,0x95,0xc8,
        0x7d,0x24,0xd0,0x15,0xd8,0x8e,0x5c,0x50,0xd1,0xe4,0xd8,0xa3,0xba,0xbd,0xca,0x95,
        0xd2,0xf3,0xf9,0xdb,0xc3,0x0e,0x17,0x71,0x6f,0xff,0xa3,0xea,0xec,0x12,0x0e,0x05,
        0xcd,0x1e,0x1d,0x80,0xa4,0xfe,0x8e,0x31,0xc5,0x45,0xfe,0x52,0x4c,0x2e,0x0a,0x1d,
        0x61,0xd2,0xb5,0x99,0xba,0x9e,0x09,0xb3,0x62,0x03,0x02,0x90,0xb9,0x6f,0xa7,0x22,
        0xbd,0x7d,0x7a,0xf9,0x87,0x69,0x12,0x5c,0x18,0xc6,0x07,0x99,0x56,0x73,0x0e,0x99,
        0x52,0xcb,0x65,0xb7,0xcc,0x1c,0x72,0xd2,0xf9,0x5a,0xa7,0xa1,0x84,0x15,0xa8,0x47,
        0xd2,0xa9,0xb0,0x28,0x8a,0xb5,0x31,0xfa,0x55,0xce,0xba,0x1f,0xe2,0x74,0x1e,0x32,
        0x2e,0x44,0xd3,0xe0,0x02,0x70,0x98,0xf9,0xbd,0x6d,0x5a,0xc6,0x53,0xeb,0x59,0x9e,
        0x96,0x0a,0x87,0xb4,0xb4,0xcb,0x30,0x33,0x01,0xc4,0xe0,0x8d,0xf7,0x19,0x82,0x0f,
        0x7b,0xa7,0xc5,0xba,0x62,0x82,0xc4,0x4e,0x34,0xa2,0xe5,0xa7,0x30,0xd9,0x01,0x4c,
        0x90,0x08,0xc6,0x46,0x0e,0x93,0x5a,0x2e,0xa6,0x12,0x41,0x8a,0x9e,0x4a,0x81,0x5a,
        0xc4,0x5b,0x04,0xed,0xf7,0x3a,0x3d,0xf9,0xe8,0x62,0x0f,0xeb,0x22,0xc7,0xea,0x7c,
        0x48,0x0c,0x37,0x85,0x9e,0xf5,0xf6,0x14,0xcb,0x1f,0xa5,0xbf,0xde,0xef,0x64,0x38,
        0x8e,0xc8,0x58,0x22,0xc6,0x81,0x4d,0x23,0x61,0x16,0x9f,0x3b,0x32,0x9d,0x5a,0x54,
        0x47,0x7c,0xa0,0x1a,0x6e,0xda,0x4b,0x0c,0xf9,0x53,0xd4,0xd3,0xbf,0xf0,0x74,0xd3,
        0x63,0x56,0x88,0x01,0xd9,0x3d,0x3a,0xf4,0x25,0x24,0x5e,0x3e,0x66,0x43,0x9a,0xfc,
        0x14,0xc2,0xca,0xac,0x86,0x28,0xa2,0x3f,0xb7,0x16,0x95,0x6f,0x49,0x35,0xf6,0x53,
        0xca,0x6d,0x5e,0x31,0x37,0x58,0x4d,0x93,0xbe,0xf6,0x14,0x9d,0xc8,0xa2,0xf2,0x9d,
        0x37,0x44,0x7d,0xe4,0xec,0xc9,0x43,0xd5,0x8d,0xd0,0xb2,0x3b,0x85,0xa6,0x35,0xe0,
        0x4c,0x75,0xa0,0x5b,0xe8,0xb8,0xce,0x29,0xb4,0xf2,0x88,0xff,0x60,0xa0,0xa9,0x5f,
        0x39,0x6c,0x80,0x6a,0xaa,0xa3,0x76,0xf5,0x03,0xe9,0xf1,0xde,0x7a,0x2c,0x78,0xa0,
        0x70,0xd6,0x17,0x26,0xf5,0x47,0x05,0xdd,0x8d,0x82,0x84,0x0d,0x34,0x26,0x09,0x69,
        0xa1,0xa1,0x9d,0xe5,0xc8,0xa0,0x83,0xc7,0xa2,0xc9,0x1b,0x01,0x30,0xad,0x06,0xbe,
        0xbe,0xf8,0x8b,0x3b,0x65,0xeb,0x39,0xd8,0xd3,0x0d,0xce,0x6f,0x4f,0x1d,0x58,0xe4,
        0xf7,0x4a,0x9a,0xfd,0x4c,0xa7,0xb1,0x74,0xf1,0xd9,0xf8,0x4b,0xb0,0x12,0x28,0x60,
        0xbe,0x44,0xc4,0x41,0x40,0x8e,0xb4,0x41,0x0d,0xfb,0x2f,0xcc,0xb6,0x6b,0xdf,0xf7,
        0xc4,0xd1,0x40,0x5b,0x40,0x9f,0x4a,0x24,0x79,0x7f,0x4f,0x65,0x01,0x44,0x26,0xaf,
        0xf9,0x20,0x89,0xe1,0x8e,0x17,0xbc,0x41,0xc4,0xb3,0x6f,0xcc,0x73,0xfa,0xe6,0xcb,
        0x8e,0x9d,0x57,0xa7,0xab,0x72,0x94,0xfe,0xc0,0x24,0xe9,0xf6,0x2b,0x2a,0x48,0xd2,
        0xf6,0xf5,0xa3,0xc3,0x58,0x6e,0x9a,0x00,0x7f,0x9f,0x56,0x18,0x8c,0xb0,0xb5,0x87,
        0xe0,0x16,0xa7,0x88,0x96,0x07,0xd8,0x2b,0x50,0x31,0x8f,0xa7,0x37,0xab,0xd6,0xf1,
        0x3d,0x2c,0xdb,0x8e,0xa6,0x7b,0x96,0xa5,0xc6,0x26,0xac,0x58,0x0c,0x77,0x93,0x54,
        0x3f,0xa4,0xf7,0xa7,0x08,0x46,0x5d,0xd3,0xb1,0x0c,0x07,0x20,0x2c,0xb1,0x17,0x36,
        0x57,0x2b,0xf7,0xea,0x7e,0x26,0xf7,0x59,0x21,0xb0,0x38,0x33,0xf8,0x36,0xca,0x5a,
        0x35,0xaf,0x11,0xac,0x09,0x17,0x6d,0x1c,0x69,0x1f,0x19,0x08,0x12,0x23,0x54,0xc7,
        0xcb,0x5c,0xbf,0x81,0xea,0x57,0x07,0x43,0x19,0xa5,0xc3,0x52,0x5a,0xd5,0xa0,0xc0,
        0x49,0x9f,0xbb,0x3e,0xa1,0x62,0x4e,0x31,0x02,0xd1,0x8f,0x08,0xf2,0xe8,0xd5,0xcc,
        0x21,0x26,0xfd,0xf8,0xf1,0xf6,0x0c,0x8c,0x35,0x6e,0x15,0x5d,0x39,0x3b,0x5e,0xaf,
        0x04,0xdc,0xbe,0x05,0xd9,0x0f,0x49,0x38,0x04,0x89,0x30,0xc7,0xd3,0xea,0xe2,0x6e,
        0xe2,0xf0,0x77,0xfa,0x9b,0xeb,0x4f,0x5b,0xfe,0x71,0xf6,0xfb,0x9e,0x52,0x4b,0x4e,
        0xec,0xce,0xe2,0xab,0xb8,0x06,0xa6,0x5a,0xf5,0xb1,0xc3,0xee,0xbd,0x10,0xc3,0xd4,
        0x95,0x24,0xf6,0x2d,0xf1,0x1e,0x18,0xd9,0xfb,0x17,0x2e,0xd4,0x90,0x01,0xb1,0xc6,
        0x8b,0xde,0xee,0xd5,0x47,0x30,0xad,0xbe,0x5f,0xb0,0x11,0x24,0xb8,0x42,0xbf,0x28,
        0xc2,0x29,0x42,0x39,0xfa,0x77,0xaf,0x2d,0xb4,0xc8,0x84,0x91,0x17,0x30,0xd6,0x3e,
        0x69,0x72,0xac,0x2d,0x8d,0x73,0xa6,0x8d,0xc9,0xee,0xe2,0x12,0xcd,0x68,0x1f,0x8f,
        0xf1,0x67,0x23,0xc7,0xbf,0xdf,0x5b,0x81,0xb1,0xed,0xc2,0xda,0x3b,0xc7,0x03,0xdf,
        0x0c,0xf4,0xe2,0x5b,0x92,0xb8,0xd8,0xee,0xbc,0xd3,0xfd,0x5f,0x03,0x6b,0x2c,0x33,
        0xab,0x46,0x61,0x7f,0x46,0x3c,0x65,0xfa,0x7b,0xec,0xae,0x56,0x05,0xaf,0x80,0xd1,
        0xfe,0xca,0x59,0x07,0x5e,0xe8,0x8c,0x0a,0xbf,0xc7,0x2c,0xb4,0x63,0x31,0x2b,0x3c,
        0x77,0x2e,0xc3,0x08,0x99,0x78,0x15,0xc2,0x99,0x2f,0x11,0xae,0x7c,0xce,0x95,0x3b,
        0xc7,0x5e,0xd9,0xd8,0xfa,0xe9,0x0a,0x08,0x5a,0x32,0x35,0xb9,0xf3,0xa3,0x67,0xd2,
        0xde,0x87,0x13,0x0b,0xc0,0x79,0xb3,0x01,0x93,0x1c,0xb2,0x8a,0xa9,0x0d,0x8a,0x45,
        0xed,0x16,0x2a,0x76,0x6d,0xa5,0x9a,0x11,0x15,0x7c,0xe1,0x15,0xbd,0xa9,0x27,0x1b,
        0x67,0xb9,0x17,0x2f,0xc1,0x29,0x87,0xde,0xf2,0x1d,0x5b,0x90,0x92,0x54,0xa6,0x19,
        0xfa,0x5c,0x13,0x8a,0xbf,0x02,0x84,0x4d,0x79,0x0d,0xf8,0x71,0xc9,0x2c,0xb2,0x42,
        0x9a,0x2c,0x98,0x1d,0xa6,0x6e,0xd9,0x82,0x3c,0x99,0xd2,0x6b,0x41,0x8c,0x33,0xdc,
        0x76,0x97,0x5d,0xbc,0xf8,0xea,0x0f,0xe3,0x0d,0x4d,0x42,0x74,0x1d,0x12,0x51,0x6d,
        0xff,0x48,0x5d,0x7c,0x77,0x32,0xf0,0x15,0xfc,0xf8,0xe0,0xc1,0xbe,0x9b,0x77,0xb9,
        0xe7,0x2e,0xd0,0xb3,0x21,0x44,0x84,0xfc,0x59,0xa5,0x87,0xc7,0xc3,0x45,0x4c,0xc5,
        0x1f,0x76,0x30,0xf5,0x3a,0x5c,0x15,0xbe,0xb7,0xa1,0x4d,0x3b,0x0f,0x6b,0xbb,0xd6,
        0xd7,0x8b,0x34,0x18,0x42,0xf8,0x2b,0xbf,0xe6,0x7b,0x8e,0x11,0xc3,0xab,0xeb,0x71,
        0x81,0x1c,0xd7,0x30,0xf9,0xd4,0x90,0xa5,0xf7,0xfe,0xe1,0x80,0x3e,0xe3,0x46,0x5b,
        0xcd,0x15,0x51,0x92,0x61,0xed,0x4c,0x55,0x3b,0x38,0x20,0xfb,0x23,0x2e,0x76,0x99},
        {0},
        /*TST_Expected_output_data for enc Input data for decrypt*/ 
        {0x0f,0x43,0xac,0x65,0xac,0x15,0x95,0x65,0x43,0x77,0x92,0x81,0x02,0xf0,0xe8,0xa7,
        0xfa,0xd6,0xae,0xf8,0x6e,0x16,0x79,0x72,0x71,0xd2,0x8d,0xf8,0xeb,0xa2,0xb8,0x3b,
        0xd3,0x2e,0xd0,0x20,0x93,0xfb,0xff,0x53,0x6f,0x1d,0x5e,0x4f,0x5c,0xff,0xdb,0x74,
        0x25,0x0a,0x6d,0xed,0x08,0x67,0xfc,0x1a,0xa5,0x51,0xcd,0xce,0x11,0xb0,0x95,0xa4,
        0x8e,0x4d,0xcd,0x76,0x88,0x3f,0xce,0x74,0x22,0xe5,0xc0,0x5f,0x43,0x5d,0x71,0x81,
        0xbb,0x83,0xec,0x80,0x09,0x98,0x4b,0xc4,0x22,0xcf,0x40,0x86,0x91,0x6f,0x0d,0x35,
        0xd7,0x80,0xce,0x0a,0x53,0x9f,0x83,0x6c,0x94,0x41,0x65,0xac,0xa0,0xa1,0x67,0x98,
        0x55,0x53,0x09,0x54,0x18,0xaf,0xa9,0xc3,0xc4,0x90,0x48,0x66,0x8d,0xb6,0x3c,0xaa,
        0x91,0xfb,0x49,0x8c,0x9a,0xf6,0x51,0xde,0x8a,0x84,0x2a,0xf1,0xf2,0x8e,0xce,0xe0,
        0x7a,0x8e,0x4c,0x42,0x4d,0x97,0xb6,0xdb,0x61,0x3d,0x85,0x26,0x56,0xbe,0x22,0x50,
        0xe8,0xda,0xa2,0x1a,0xed,0xa8,0xf3,0x84,0x1c,0x72,0x0a,0x0c,0x7b,0x4b,0x98,0x0a,
        0x5f,0x35,0xed,0xdc,0x5e,0xd3,0xc8,0x85,0x79,0x9b,0x5d,0xd7,0x30,0x0a,0x67,0x24,
        0x3d,0xa4,0x6a,0xb5,0x1e,0xa1,0x31,0xe9,0x4a,0x64,0xfe,0xfc,0xfa,0x78,0xe1,0x94,
        0x5c,0x29,0xa9,0x65,0x5c,0x85,0x0a,0xc1,0xaa,0xe8,0x61,0xe3,0xb7,0x49,0x89,0x5a,
        0x84,0x3a,0xf1,0xd0,0x8d,0xde,0x57,0x35,0xaf,0x8d,0x1c,0xf8,0xf5,0xab,0xec,0xff,
        0x9c,0x37,0xd1,0xce,0xef,0xbf,0x16,0xf8,0xd0,0x9b,0x97,0xea,0x7f,0x96,0x35,0xc7,
        0x9e,0x50,0x6a,0xea,0x78,0xfd,0x58,0x6f,0xb6,0x22,0x77,0x7c,0xed,0x9d,0x32,0xfb,
        0x85,0x95,0xb5,0xa5,0xa9,0xef,0xa5,0x1d,0xac,0xf7,0x8a,0x55,0x76,0x15,0x23,0xee,
        0xd4,0x46,0x09,0x89,0xdb,0x7f,0x39,0xf8,0xd7,0xc8,0x09,0x45,0x41,0xe9,0xcf,0x41,
        0xfe,0x47,0xf6,0xb2,0x49,0x1b,0xfb,0x4b,0x11,0x52,0xe2,0xe6,0xc0,0x62,0x76,0xbd,
        0xd8,0x15,0xa2,0x60,0x8f,0x88,0x13,0xdd,0x2c,0xa5,0x48,0xd8,0xc0,0x47,0xd3,0x83,
        0xc3,0x70,0x14,0x71,0x48,0xbb,0x98,0x60,0xf3,0xd8,0x4b,0xee,0x44,0x98,0x6f,0x7b,
        0x60,0x27,0xfb,0x60,0x17,0xf1,0x1a,0x0c,0x73,0xcc,0x39,0xbf,0xa2,0x5a,0x27,0xdc,
        0x4a,0x12,0x1a,0x44,0x25,0x57,0x33,0xb6,0x8b,0x5f,0x96,0xfb,0xe9,0xb4,0x97,0xea,
        0x12,0x4d,0x39,0x47,0xaa,0xec,0x96,0x1b,0xc6,0xc7,0x02,0xd1,0xeb,0x33,0x21,0x1b,
        0x7d,0x37,0x43,0x85,0x9a,0x39,0xc9,0xea,0x05,0xe2,0xff,0xf0,0x09,0xda,0x33,0x4b,
        0x5d,0x35,0x84,0x62,0xb9,0x63,0xa5,0xa4,0x5d,0x92,0x86,0x04,0x32,0x0d,0x04,0x2a,
        0x6e,0x90,0x64,0xec,0xe3,0x1f,0x3d,0x80,0xda,0xbe,0xcc,0x28,0x0a,0x58,0x0e,0x4c,
        0x33,0x5a,0xe6,0xeb,0x2e,0xac,0x18,0x7c,0x2d,0x10,0xeb,0xb0,0xf1,0x81,0x66,0x84,
        0xbe,0x67,0x3a,0x7c,0xbc,0xa7,0x68,0x89,0xd6,0x5a,0x90,0x87,0x08,0xf6,0x70,0x66,
        0x38,0xb8,0xc3,0x00,0xe7,0x59,0x4d,0x42,0x21,0xbd,0xbb,0x8b,0x19,0x1e,0xee,0x87,
        0xec,0xc7,0xb9,0xa9,0x98,0xf3,0xb8,0x96,0xb1,0xce,0xa8,0x6c,0x94,0xe8,0xb7,0x8a,
        0xf5,0x82,0x28,0xb8,0x5f,0xa5,0x58,0x50,0xed,0xac,0x65,0x69,0x4a,0x7a,0xb4,0x0f,
        0x24,0x25,0xb0,0x89,0x03,0x47,0x94,0x30,0x1f,0x81,0xc2,0x4e,0xa8,0xea,0x2f,0x79,
        0x20,0x5f,0x7d,0x7f,0xd2,0x35,0x76,0x7d,0xbe,0xf7,0xa1,0xce,0xa7,0x5b,0x4c,0xe5,
        0x0a,0xd3,0x4d,0xdf,0xb9,0xeb,0x66,0x8e,0xed,0x2a,0x36,0x2c,0xcf,0xa1,0x40,0x82,
        0xb7,0x4b,0x91,0xc9,0x57,0x29,0xc5,0xb4,0x0c,0x15,0x5c,0x42,0x68,0x23,0x65,0x54,
        0x45,0xc4,0x9a,0xb3,0x14,0xdc,0x18,0x14,0xa0,0xf2,0xb5,0xc0,0x03,0x1f,0x12,0x1a,
        0x4c,0x80,0xe4,0x70,0xd4,0x94,0x62,0x9a,0x05,0xf1,0x3a,0x27,0x7c,0x75,0xc7,0x7c,
        0x83,0xb6,0x98,0xa7,0xd1,0x8d,0xa8,0xc7,0x8f,0x93,0xdc,0x1e,0xa8,0x4e,0xc5,0x86,
        0xe6,0x76,0x59,0x43,0x0c,0x5b,0xa5,0xeb,0xcc,0xe1,0xc7,0x90,0x2e,0xd7,0x2d,0xf8,
        0x6a,0x9e,0x4d,0x91,0xc0,0x9c,0x39,0x1e,0x10,0xce,0x58,0x0e,0x62,0xce,0x08,0x74,
        0xa4,0x92,0xd6,0x85,0x00,0xf5,0x1b,0x4c,0xd4,0x8e,0xb9,0x33,0xf7,0xee,0x77,0x63,
        0x72,0x73,0x06,0x93,0x7e,0x1f,0xd3,0xf7,0xa7,0x28,0x23,0xc6,0x08,0x3a,0x31,0x89,
        0x1f,0xa4,0xc7,0x89,0x99,0xdb,0xd8,0x1e,0x8a,0x82,0x0c,0x1c,0xed,0x2c,0x86,0x46,
        0xba,0x7d,0xcb,0x58,0x1a,0xe4,0x39,0xc2,0xea,0xa6,0x49,0x22,0x13,0xc5,0xe8,0xed,
        0x6e,0x52,0x03,0x21,0x25,0xd0,0x5e,0x18,0x29,0x8b,0x98,0x47,0xee,0x03,0x27,0x8a,
        0xb7,0xec,0xb3,0x33,0x1a,0xaf,0x28,0x21,0xc9,0x48,0x98,0x0c,0xf2,0xa9,0xea,0x2d,
        0xfa,0x45,0xb7,0x89,0x1d,0x06,0xae,0xcf,0x38,0x53,0xee,0xe8,0x24,0x96,0xad,0x33,
        0xa7,0xc0,0x23,0x69,0x23,0x77,0x22,0x71,0x22,0x63,0xe3,0x78,0x44,0x96,0xda,0x2d,
        0x85,0xec,0xb0,0x12,0xcb,0xcf,0xb3,0xdc,0x70,0x37,0xb4,0x51,0x3c,0x35,0xea,0x9d,
        0x1d,0x0a,0x64,0x7b,0xff,0x4b,0x33,0xea,0x44,0xdc,0xf6,0xc8,0xb4,0x3c,0x1c,0x5b,
        0x23,0xe4,0xc4,0x7f,0x2e,0x64,0x6e,0xf4,0x60,0xf9,0x3f,0x83,0xbb,0xb7,0x8e,0x5e,
        0x8a,0xe8,0x97,0x9e,0xb4,0x59,0x49,0x6f,0x1e,0x6a,0x76,0x46,0x2f,0x6d,0x75,0x5d,
        0x94,0xf6,0x72,0xac,0xef,0x3f,0x1a,0x9d,0xe8,0x01,0xdf,0x17,0xa6,0xab,0x3d,0x3f,
        0x0a,0x36,0x02,0x1a,0xc9,0xe2,0x0d,0x20,0x66,0xc8,0x87,0x27,0x86,0x8f,0x50,0x14,
        0x46,0xb5,0x95,0x61,0xc4,0x12,0x35,0x1b,0xc9,0x6f,0x02,0xf6,0xc3,0x6c,0xf9,0x5d,
        0x2f,0x66,0x34,0xa6,0x0a,0x51,0xa9,0x80,0xf7,0xe3,0x02,0xea,0x87,0x52,0xde,0x22,
        0x3d,0xd0,0x3d,0xf9,0x57,0xd7,0x9b,0xa4,0xc2,0xd3,0xbd,0x48,0x28,0x53,0x9c,0x45,
        0x0a,0xca,0x5c,0x2d,0x22,0x35,0xea,0xb3,0x60,0xc6,0x23,0x1d,0x12,0x8e,0xcb,0xb7,
        0x3b,0x25,0x2c,0x01,0x1d,0xef,0x2a,0x14,0x6f,0x2f,0x79,0xf7,0x20,0x4e,0x6e,0x26,
        0x42,0x11,0x4f,0x59,0x67,0x5a,0x5b,0x2a,0x2d,0x7b,0x64,0x80,0x04,0x00,0xe6,0x69,
        0x2f,0xc5,0x3c,0xfa,0x56,0x0b,0xff,0x29,0x62,0x3f,0x4c,0x47,0x3a,0x46,0xe7,0xb1,
        0xee,0x97,0x86,0x0a,0x7c,0x1f,0xe4,0x80,0x76,0x9c,0x8e,0x2b,0x7f,0xae,0x59,0x57,
        0x9b,0xa5,0x68,0xfb,0x30,0xe4,0x02,0x45,0xe5,0x7b,0xcd,0xfa,0x8d,0x06,0xd7,0xaf,
        0x71,0xbd,0x50,0x62,0x3e,0xb3,0xc8,0x6b,0x8a,0xc1,0x79,0xdd,0x20,0x66,0x56,0x09,
        0x01,0x39,0xa1,0x30,0x54,0x46,0x1c,0x40,0x2e,0xbd,0x9a,0x3f,0x27,0xb9,0x58,0xbb,
        0x22,0xab,0x2b,0x0a,0x36,0xce,0xfb,0xe8,0xb2,0x35,0xb7,0x8c,0xfa,0x18,0x86,0x4d,
        0x3d,0xb5,0x30,0x37,0x84,0x0f,0x52,0x68,0x3c,0xbc,0xd0,0x36,0xcb,0x0c,0xc1,0x42,
        0x92,0xeb,0xee,0xad,0xd0,0x8a,0x83,0xd1,0x02,0xba,0x93,0x7d,0xd1,0x8d,0xd1,0xd9,
        0x83,0xaa,0x47,0xdf,0x09,0x60,0x65,0xc0,0x83,0x82,0xda,0x95,0x7e,0xff,0x74,0xa0,
        0x43,0x23,0x2e,0xd5,0x34,0xc5,0x77,0x7a,0x30,0xfb,0x0a,0xd4,0xe4,0xd4,0x56,0xac,
        0x20,0xd2,0xeb,0x41,0xb0,0x08,0x68,0xb0,0x48,0xa9,0x89,0xfc,0xbb,0x3e,0x73,0x30,
        0x85,0x81,0x63,0x65,0x1e,0x61,0x46,0x13,0x15,0x87,0xa5,0x60,0x06,0xd3,0x1f,0x11,
        0x53,0x6d,0xa0,0xc3,0x36,0x5a,0x2f,0x1d,0x76,0xef,0xb6,0x81,0x9a,0x0a,0x76,0x60,
        0xe9,0x86,0x70,0xeb,0x4d,0xf8,0x6f,0x99,0x64,0x9c,0x3e,0x59,0x7a,0x3f,0xdb,0x4e,
        0xa3,0x80,0xd7,0xce,0xe4,0x5a,0xaa,0xb8,0xf1,0x68,0x77,0xa2,0x31,0x30,0x9c,0x6f,
        0x80,0x9d,0xe7,0xb4,0xbf,0x2e,0x56,0x61,0x1b,0x8d,0x1c,0x9a,0x6e,0x12,0xc7,0x57,
        0x99,0x98,0x09,0xae,0xb1,0x55,0x3e,0xd5,0x63,0xad,0xfd,0xc9,0xf0,0x3f,0xac,0xdb,
        0x93,0x45,0x83,0xc6,0x21,0x98,0xc3,0x58,0xdf,0x6e,0xa0,0x24,0xab,0x12,0xf4,0xee,
        0xda,0xe6,0x02,0x34,0xf1,0xa3,0x93,0xd8,0x76,0x42,0xd5,0x45,0x5e,0x03,0xb4,0xaa,
        0x40,0x0a,0x59,0xf6,0x55,0xb7,0xbb,0xaf,0x15,0x6f,0x53,0x02,0xa2,0x09,0xab,0xd4,
        0xd3,0xf4,0x6e,0xec,0x1d,0x8c,0xf3,0xaa,0x7f,0xb7,0x08,0x92,0xd9,0x91,0x9f,0xd1,
        0xbf,0x91,0xb3,0x76,0x14,0xb8,0xb9,0x7b,0x1f,0xa9,0xda,0x02,0x80,0x23,0xe5,0x86,
        0x85,0x65,0xae,0x7f,0x04,0x9f,0xe5,0x79,0xb4,0xd6,0x06,0x57,0x95,0xc6,0xe6,0xcf,
        0x73,0xf8,0x5e,0x9a,0x2f,0xd3,0xa7,0x38,0xdb,0xe5,0x8b,0x13,0xba,0x21,0x7d,0x5a,
        0x97,0x44,0xeb,0xd5,0xb8,0x24,0xef,0x17,0xbc,0x6d,0x8d,0xf6,0x16,0x07,0xf5,0xe4,
        0x2f,0xb2,0x95,0xec,0x33,0x5e,0xac,0x64,0x29,0xcc,0xee,0x75,0x27,0x30,0xf1,0x9e,
        0x52,0x36,0xd9,0xa5,0xfc,0x02,0xff,0x12,0xad,0x1e,0x58,0xac,0x05,0x9d,0x73,0x79,
        0xbd,0x9f,0x0d,0x00,0xd8,0x0f,0xa2,0x6e,0x85,0x4a,0x19,0x5b,0xc2,0xa1,0xb0,0xc7,
        0xc1,0xad,0x1e,0x63,0x4a,0x25,0xab,0x9f,0x53,0x03,0x56,0xef,0x8e,0x4c,0xc8,0xd8,
        0xbd,0x8b,0xdb,0xf7,0x4b,0xaf,0xb4,0x59,0x1f,0x47,0x63,0x5c,0x5e,0x1f,0xb3,0x51,
        0xad,0xc6,0xdc,0xd5,0x7d,0xb8,0x0d,0x91,0xb5,0xb0,0x39,0x56,0x13,0xfb,0xd4,0xd5,
        0x93,0xa6,0x27,0x2f,0xeb,0xb6,0xe0,0xb8,0xd9,0x97,0x13,0x95,0xd9,0x65,0xaf,0x40,
        0x3b,0x00,0xe4,0x38,0xa3,0x87,0xd4,0x0a,0x20,0x42,0x6c,0xec,0x19,0xf1,0x1a,0xba,
        0xb6,0x67,0xcf,0x92,0x5e,0x2d,0xe8,0x9a,0x5b,0x08,0xc9,0x88,0x47,0x26,0x9e,0x18},  
        /*TST_dataSize*/
        1536*sizeof(DxUint8_t),       
        CRYS_DES_ECB_mode 
    } 
    
};



